package Model.Classes;

import java.util.Set;

import Model.Exceptions.ValidationException;

/**
 * Represents a User. Every User have many Items.
 * 
 * @author Tamir Schwartzberg (tamir5021@gmail.com).
 */
public class User {

	/**
	 * Represents the Users id.
	 */
	private int id;

	/**
	 * Represents the Users name.
	 */
	private String name;

	/**
	 * Represents the Users user_name.
	 */
	private String userName;

	/**
	 * Represents the Users password.
	 */
	private String password;

	/**
	 * Represents the Users Set of items.
	 */
	private Set<Item> items;

	public User() {
		super();
	}

	/**
	 * Creates a Users with a specified name, user_name and password.
	 * 
	 * @param name
	 *            The Users name.
	 * @param userName
	 *            The Users user_name.
	 * @param password
	 *            The Users password.
	 * @throws ValidationException
	 */
	public User(String name, String userName, String password) throws ValidationException {
		setName(name);
		setUserName(userName);
		setPassword(password);
	}

	/**
	 * Gets the Users Id.
	 * 
	 * @return An integer number representing the Users id.
	 */
	public int getId() {
		return id;
	}

	/**
	 * Sets the Users id.
	 * 
	 * @param id
	 *            An integer number containing the Users id.
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the Users name.
	 * 
	 * @return A string representing the Users name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the Users name.
	 * 
	 * @param name
	 *            A string containing the Users name.
	 * @throws ValidationException
	 */
	public void setName(String name) throws ValidationException {
		Validator.checkName(name);
		this.name = name;
	}

	/**
	 * Gets the Users user_name.
	 * 
	 * @return A string representing the Users user_name.
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * Sets the Users user_name.
	 * 
	 * @param userName
	 *            A string containing the Users user_name.
	 * @throws ValidationException
	 */
	public void setUserName(String userName) throws ValidationException {
		Validator.checkUserName(userName);
		this.userName = userName;
	}

	/**
	 * Gets the Users password.
	 * 
	 * @return A string representing the Users password.
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * Sets the Users password.
	 * 
	 * @param password
	 *            A string containing the Users password.
	 * @throws ValidationException
	 */
	public void setPassword(String password) throws ValidationException {
		Validator.checkPass(password);
		this.password = password;
	}

	/**
	 * Gets the Users Set of items.
	 * 
	 * @return A Set<Item> representing the Users Set of items.
	 */
	public Set<Item> getItems() {
		return items;
	}

	/**
	 * Sets the Users Set of items.
	 * 
	 * @param items
	 *            A Set<Item> containing the Users Set of items.
	 */
	public void setItems(Set<Item> items) {
		this.items = items;
	}

	@Override
	public String toString() {
		return "[" + id + ", " + name + ", " + userName + ", " + password + ", " + items.size() + "]";
	}

	@Override
	public boolean equals(Object other) {
		if (other == null)
			return false;
		if (other == this)
			return true;
		if (!(other instanceof User))
			return false;
		User otherUser = (User) other;
		if ((id != otherUser.getId()) || (!name.equals(otherUser.getName()))
				|| (!userName.equals(otherUser.getUserName())) || (!password.equals(otherUser.getPassword())))// ||
																												// (items.size()
																												// !=
																												// otherUser.items.size()))
			return false;
		return true;
	}
}